package org.simantics.views.swt;

import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.graph.impl.GraphInputSources;
import org.simantics.browsing.ui.graph.impl.InputSourceListener;
import org.simantics.browsing.ui.graph.impl.ObservableInputSource;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.graph.impl.WorkbenchSessionContextInputSource;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableRepository;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.views.ontology.ViewsResources;
import org.simantics.views.swt.client.base.SWTRoot;

public class SWTViewLoaderProcess extends ScenegraphLoaderProcess {

	final private ModelledView view;
	final private IWorkbenchSite site;
	
	public static class ISL implements InputSourceListener {
		
		private SWTViewLoaderProcess process;
		
		ISL(SWTViewLoaderProcess process) {
			this.process = process;
		}
		
		void dispose() {
			process = null;
		}
		
        @Override
        public void inputChanged(SessionContextInputSource source) {
        	if(process == null) return;
            Object input = source.get( Simantics.getSessionContext() );
            if (input != null)
                process.view.inputChanged(source.getProvider(), input);
            else
                ErrorLogger.defaultLogWarning("input source " + source + " invalidly returned null", new Exception("for stack trace only"));
        }
	};
	
    ISL inputSourceListener = new ISL(this);
	
	public SWTViewLoaderProcess(ModelledView view, IWorkbenchSite site, String name) {
		super(name);
		this.view = view;
		this.site = site;
		this.root = new SWTRoot(site);
	}

	public SWTViewLoaderProcess(ModelledView view, IWorkbenchSite site) {
		this(view, site, "<unnamed SWTViewLoaderProcess>");
	}

	@Override
	public INode getRoot() {
		return root;
	}
	
	@Override
	protected void initialize(RequestProcessor processor, final Variable configuration) throws DatabaseException {
		
		SessionContextInputSource inputSource = processor.sync(new UniqueRead<SessionContextInputSource>() {
			@Override
			public SessionContextInputSource perform(ReadGraph graph) throws DatabaseException {
				ViewsResources VIEW = ViewsResources.getInstance(graph);
				Resource represents = configuration.getRepresents(graph);
				Resource inputSource = graph.getPossibleObject(represents, VIEW.HasInputSource);
				if (inputSource == null)
					return GraphInputSources.projectSource();
				return graph.adapt(inputSource, SessionContextInputSource.class);
			}
		});

        if(view != null)
            view.setInputSource(inputSource);

        if (inputSource instanceof ObservableInputSource)
            ((ObservableInputSource) inputSource).setListener(inputSourceListener);

        if (inputSource instanceof WorkbenchSessionContextInputSource)
			((WorkbenchSessionContextInputSource) inputSource).init(site, view);

	}
	
	@Override
	public void dispose() {
		
		if (isDisposed())
			return;
		
		inputSourceListener.dispose();
		for(String uri : registeredURIs) VariableRepository.unregister(uri);
		SWTRoot r = (SWTRoot)root;
		r.dispose();
		
		super.dispose();
		
	}

}
