package org.simantics.views;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.views.ViewUtils.ColumnBean;
import org.simantics.views.ontology.ViewsResources;

public class All {

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object resourceURI(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	
    	ViewsResources VIEW = ViewsResources.getInstance(graph);
    	Resource resource = graph.getSingleObject(converter, VIEW.ResourceURI_HasResource);
    	return graph.getURI(resource);
        
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object parameterValue(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	
    	Variable runtime = ScenegraphLoaderUtils.getRuntimeVariable(graph, context);
    	Variable base = ScenegraphLoaderUtils.getBaseVariable(graph, context);
    	//System.err.println("parameterValue " + context.getURI(graph) + " " + base.getURI(graph) + " " + runtime.getURI(graph));
    	String rvi = context.getURI(graph).substring(base.getURI(graph).length());
    	//System.err.println("rvi " + rvi);
    	Variable parameter = runtime.browse(graph, rvi);
    	return parameter.getValue(graph);
        
    }
    
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> Resource")
    public static Resource singleResourceSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
    	return ScenegraphLoaderUtils.getPossibleResourceSelection(graph, context);
    }
    
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> [String]")
    public static List<String> tabChildNames(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	
    	Collection<Variable> children = context.getParent(graph).getChildren(graph);
    	
    	List<String> result = new ArrayList<String>();

		for(Variable child : children) {
			String label = child.getPropertyValue(graph, Variables.LABEL); 
			result.add(label);
		}
		
		return result;    	
        
    }
    
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object bundleImage(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	
    	ViewsResources VIEW = ViewsResources.getInstance(graph);
    	String reference = graph.getRelatedValue(converter, VIEW.BundleImage_HasReference);
    	
    	String[] parts = reference.split(":");
    	if(parts.length != 2) return null;
    	
        Bundle bundle = Platform.getBundle(parts[0]);
        
        if (bundle == null) {
            throw new IllegalArgumentException("null bundle");
        }

        // look for the image (this will check both the plugin and fragment folders
        URL fullPathString = FileLocator.find(bundle, new Path(parts[1]), null);
        if (fullPathString == null) {
            try {
                fullPathString = new URL(parts[1]);
            } catch (MalformedURLException e) {
                return null;
            }
        }
        
        try {
			return StreamUtil.readFully(fullPathString.openStream());
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
        
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object gridData(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getGridData(graph, converter);
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object gridLayout(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getLayout(graph, converter);
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object rowData(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getRowData(graph, converter);
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object rowLayout(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getRowLayout(graph, converter);
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object style(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	return ViewUtils.getStyle(graph, converter);
    }
    
    @SCLValue(type = "ReadGraph -> Resource -> a -> b")
    public static Object columnList(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
    	ArrayList<ColumnBean> result = new ArrayList<ColumnBean>();
    	for(Resource item : ListUtils.toList(graph, resource)) {
    		result.add(ViewUtils.getColumn(graph, item));
    	}
    	return result;
    }
    
    
}