/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.validators;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * A JFace input validator for non-negative integers, i.e. natural numbers.
 * 
 * @author Tuukka Lehtonen
 */
public class NonNegativeIntegerValidator implements IInputValidator {
    
    /**
     * Validates an input string as a non-negative integer (Natural number).
     * @see org.eclipse.jface.dialogs.IInputValidator#isValid(java.lang.String)
     */
    public String isValid(String newText) {
        try {
            int value = Integer.parseInt(newText);
            if (value < 0) {
                return "\"" + newText + "\" is not a non-negative integer value";
            }
            return null;
        } catch (NumberFormatException e) {
            return "\"" + newText + "\" is not an integer value"; 
        }
    }
}
