package org.simantics.utils.ui.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Tool for creating random and distinct colors.
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ColorPool {
	
	private List<Color> colors;
	
	public ColorPool() {
		colors = new ArrayList<Color>();
	}
	
	public void addDefaultColors() {
		colors.add(new Color(0, 0, 255)); // blue
		colors.add(new Color(255, 0, 0)); // red
		colors.add(new Color(0, 200, 0)); // green
		colors.add(new Color(0, 0, 0)); // black
	}
	
	public List<Color> getColors() {
		return colors;
	}
	
	public Color getColor(int index) {
		if (colors.size() == 0)
			addDefaultColors();
		while (colors.size() <= index) {
			newRandomColor();
		}
		return colors.get(index);
	}
	
	public int getSize() {
		return colors.size();
	}
	
	public void add(Color color) {
		colors.add(color);
	}
	
	public void setColor(int index, Color color) {
		colors.set(index, color);
	}
	
	public void clear() {
		colors.clear();
	}
	
	private Color newRandomColor() {
		
		ArrayList<Color> sortColors = new ArrayList<Color>();
		for (Color c : colors) {
			if (!Float.isNaN(c.getH()))
				sortColors.add(c);
		}
		if (sortColors.size() > 0) {
			Collections.sort(sortColors);
			Color duplicate = new Color(sortColors.get(0));
			duplicate.setH(sortColors.get(0).getH()+360.f);
			sortColors.add(duplicate);
			
	        float maxDelta = 0;
	        int maxDeltaIndex = 0;
	        for (int i = 0; i < sortColors.size()-1; i++) {
	            float delta = sortColors.get(i + 1).getH() - sortColors.get(i).getH();
	            if (delta > maxDelta) {
	                maxDelta = delta;
	                maxDeltaIndex = i;
	            }
	        }
	        float newHue = sortColors.get(maxDeltaIndex).getH() + 0.5f * maxDelta;
	        if (newHue > 360.f)
	            newHue -= 360.f;
	        
	        Color randomColor = Color.getRandomHSV(0.5f, 0.5f);
	        randomColor.setH(newHue);
	        colors.add(randomColor);
	        return randomColor;
		} else {
			Color randomColor = Color.getRandomHSV(0.5f, 0.5f);
			colors.add(randomColor);
			return randomColor;
		}
        
	}
	
	
}
