/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/

package org.simantics.utils.threads.ua;

import java.util.EnumSet;

/**
 * State of a worker
 * 
 * Initial state: Active
 * Final state: Shutdown
 * 
 * State transitions: 
 *   -> Active -> Paused -> Active -> 
 *   -> Paused -> Closed -> Shutdown 
 *   -> Active -> Closed -> Shutdown
 * 
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public enum ExecutorState {
	
	Active,		// Accepts and executes work. (Initial State)
	Paused,		// Accepts new work and but does not execute work from queues.
	Shutdown,	// Does not accept new work but executes remaining queues. Shifts to Terminated state automatically when queue is empty. 
	Terminated;	// All threads are released and work queues are empty. Does not accept new work. (Final State)

	public static EnumSet<ExecutorState> WORKING_STATES = EnumSet.of(ExecutorState.Active, ExecutorState.Shutdown);
	public static EnumSet<ExecutorState> ACCEPTS_WORK_STATES = EnumSet.of(ExecutorState.Active, ExecutorState.Paused);
	public static EnumSet<ExecutorState> FINAL_STATES = EnumSet.of(ExecutorState.Terminated);
	public static EnumSet<ExecutorState> NON_PAUSED_STATES = EnumSet.of(ExecutorState.Active, ExecutorState.Shutdown, ExecutorState.Terminated);
	
}
