package org.simantics.utils.strings;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

public class ValidatorUtils {

   	public static Pattern alphaNumericPattern(int length) {

   		String pattern = "^(_|\\p{Alnum}){1," + length + "}+$";
   	   	return Pattern.compile(pattern);
   		
   	}
   	
   	public static Collection<StringInputProblem> errorProblem(final String text) {
   		return Collections.<StringInputProblem>singletonList(new StringInputProblem() {
			
			@Override
			public Severity getSeverity() {
				return Severity.Error;
			}
			
			@Override
			public int getEnd() {
				return 0;
			}
			
			@Override
			public String getDescription() {
				return text;
			}
			
			@Override
			public int getBegin() {
				return 0;
			}
			
		});
   	}
	
}
