/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.map;


/**
 * Description associativity of dimensions.
 * The maximum number of dimensions is 32.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public final class Associativity {
		
	public static Associativity of(boolean...dimensionAssociativity)
	{
		return new Associativity(dimensionAssociativity);
	}	
	
	public static Associativity[] fullAssociativity(int level)
	{		
		int count = (1 << level)-1;
		Associativity[] result = new Associativity[count];
		for (int i=0; i<count; i++) 
			result[i] = new Associativity(level, i);
		return result;
	}
	
	public int dimensionAssociativity;
	public int level;
	
	public Associativity(boolean...dimensionAssociativity)
	{
		if (dimensionAssociativity==null || dimensionAssociativity.length>32)
			throw new IllegalArgumentException();
		
		int mask = 1;
		for (boolean b : dimensionAssociativity) {
			if (b) this.dimensionAssociativity |= mask;
			mask <<= 1;
		}
		
		level = dimensionAssociativity.length;
	}
	public Associativity(int level, int dimensionAssociativity)
	{
		this.dimensionAssociativity = dimensionAssociativity;
		this.level = level;
	}
	
	@Override
	public int hashCode() {
		return dimensionAssociativity;
	}
	
	@Override
	public boolean equals(Object obj) {
        if (obj == null) return false;
        if (!(obj.getClass().equals(this.getClass()))) return false;        
        Associativity other = (Associativity) obj;			
		return dimensionAssociativity == other.dimensionAssociativity;
	}
	
	public int getLevel() {
		return level;
	}
	
}
