/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.hints;

/**
 * IHintTracker is an interface for tracking any hints of a single IHintContext.
 * 
 * <p>
 * The main purpose of this interface is to enable very easy switching of the
 * tracked hint context. Only a call to the {@link #track(IHintContext)} method
 * is required. All hint listeners registered into the tracked will
 * automatically be switched to listen to the new context instead. Hint
 * listeners can be added or removed while tracking an IHintContext.
 * </p>
 * 
 * <p>
 * Always be sure to {@link #untrack()} any IHintContext that you're tracking
 * after the tracker is no longer needed. Otherwise you will most likely have
 * invalid listeners within the tracked IHintContext resulting in erroneous
 * behavior.
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public interface IHintTracker extends IHintObservable {

    /**
     * Start tracking the specified IHintContext with all the listeners
     * registered into this IHintObservable. Tracking of any previous
     * IHintContext will be discontinued.
     * 
     * @param ctx the new IHintContext to track
     */
    public void track(IHintContext ctx);
    
    /**
     * A call to this method should have the same implications as a
     * <code>track(null)</code> call.
     */
    void untrack();
    
}
