/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.datastructures.hints;

import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

public class HintStackTest {

	public static final Key KEY = new KeyOf(Double.class);
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		IHintStack stack = new HintStack();
		stack.addHintListener(new IHintListener() {
			@Override
			public void hintChanged(IHintObservable sender, Key key,
					Object oldValue, Object newValue) {
				System.out.println("Hint changed: "+key+"="+newValue+" (was "+oldValue+")");
			}

			@Override
			public void hintRemoved(IHintObservable sender, Key key,
					Object oldValue) {
				System.out.println("Hint removed: "+key+" (was "+oldValue+")");
			}});
		IHintContext c1 = new HintContext();
		IHintContext c2 = new HintContext();
		
		c1.setHint(KEY, 1.0);
		c2.setHint(KEY, 2.0);
		
		// KEY added
		stack.addHintContext(c1, 0);
		// KEY overridden
		stack.addHintContext(c2, 1);
		
		// underlying removed, do not do anything
		stack.removeHintContext(c1);
		
		// add over prev value, override
		stack.addHintContext(c1, 2);
		
		// should not do anything, is overridden
		c2.setHint(KEY, 3.0);
		
		// changed. overrides c2
		c1.setHint(KEY, 4.0);
		
		// removed. c2's value 3 becomes effective
		c1.removeHint(KEY);
	}

}
