/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.cache;


/**
 * Caches the value provided by the back-end provider.
 * <p>
 * Cached version is equal to original in hashCode/equals wise.
 * 
 * @author Toni Kalajainen
 */
public class CachedProvider<V> implements IProvider<V> {

    public static final <V> IProvider<V> cache(IProvider<V> provider)
    {
        if (provider instanceof CachedProvider<?>)
            return provider;
        return new CachedProvider<V>(provider);
    }

    IProvider<V> backendProvider;
    V value;

    CachedProvider(IProvider<V> orig)
    {
        this.backendProvider = orig;
    }

    @Override
    public synchronized V get() throws ProvisionException {
        if (value==null) {
            value = backendProvider.get();
        }
        return value;
    }

    @Override
    public int hashCode() {
        return backendProvider.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return backendProvider.equals(obj);
    }

}
