/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Union<T> extends ImmutableCollection<T> {
    
    private List<Collection<T>> parts;
    
    public Union(int partCount) {
        parts = new ArrayList<Collection<T>>(partCount);
    }
    
    public void add(Collection<T> part) {
        parts.add(part);
    }

    @Override
    public boolean contains(Object o) {
        for(Collection<T> part : parts)
            if(part.contains(o))
                return true;
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for(Object o : c)
            if(!contains(o))
                return false;
        return true;
    }

    @Override
    public boolean isEmpty() {
        for(Collection<T> part : parts)
            if(part.isEmpty())
                return true;
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        
        return new ImmutableIterator<T>() {

            Iterator<Collection<T>> partIterator = parts.iterator();
            Iterator<T> iterator = null;
            
            @Override
            public boolean hasNext() {
                while(iterator == null || !iterator.hasNext()) {
                    if(!partIterator.hasNext())
                        return false;
                    iterator = partIterator.next().iterator();
                }
                return true;
            }

            @Override
            public T next() {
                if(hasNext()) 
                    return iterator.next();
                else
                    throw new NoSuchElementException();
            }
            
        };
        
    }

    @Override
    public int size() {
        int count = 0;
        for(Collection<T> part : parts)
            count += part.size();
        return count;
    }

}
