/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;


/**
 * Immutable Collection adapter that uses iterator method to implement all 
 * its methods. 
 */
public abstract class EssentiallyIterableCollection<E> extends ImmutableCollection<E> {

    @Override
    public boolean contains(Object o) {
        Iterator<E> iterator = iterator();
        while(iterator.hasNext()) 
            if(iterator.next().equals(o))
                return true;
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for(Object o : c)
            if(!contains(o))
                return false;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return iterator().hasNext();
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<E> iterator = iterator();
        while(iterator.hasNext()) {
            ++ count;
            iterator.next();
        }
        return count;
    }

}
