/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.coverage.CoverageUtils;
import org.simantics.scl.compiler.runtime.RuntimeModule;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.tests.modelled.utils.ModelledSTSSuite;
import org.simantics.tests.modelled.utils.ModelledSTSTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STSSuiteTestCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(STSSuiteTestCollector.class);

    public static Collection<ModelledSTSSuite> collectTests() throws DatabaseException {
        Collection suitess = (Collection)Simantics.getSession().syncRequest((Read)new UniqueRead<Collection<ModelledSTSSuite>>(){

            public Collection<ModelledSTSSuite> perform(ReadGraph graph) throws DatabaseException {
                List sharedOntologies = (List)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"getSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{Tuple0.INSTANCE});
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Found {} shared ontologies from graph", (Object)sharedOntologies.size());
                }
                HashSet<ModelledSTSSuite> suites = new HashSet<ModelledSTSSuite>();
                TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource sharedOntology : sharedOntologies) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Searching {} for modelled tests", (Object)graph.getURI(sharedOntology));
                    }
                    List stsSuites = ModelingUtils.searchByType((ReadGraph)graph, (Resource)sharedOntology, (Resource)TESTS.STSSuite);
                    for (Resource stsSuite : stsSuites) {
                        try {
                            Collection tests = (Collection)graph.syncRequest((Read)new ObjectsWithType(stsSuite, L0.ConsistsOf, TESTS.STSTest));
                            if (tests.isEmpty()) continue;
                            ArrayList<ModelledSTSTest> testRunners = new ArrayList<ModelledSTSTest>(tests.size());
                            for (Resource test : tests) {
                                testRunners.add(STSSuiteTestCollector.toModelledTest(graph, test));
                            }
                            suites.add(STSSuiteTestCollector.toModelledSuite(graph, stsSuite, testRunners));
                        }
                        catch (Exception e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    }
                }
                return suites;
            }
        });
        return suitess;
    }

    public static ModelledSTSTest toModelledTest(ReadGraph graph, Resource test) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
        String testName = (String)graph.getRelatedValue(test, L0.HasName, (Binding)Bindings.STRING);
        String code = (String)graph.getRelatedValue(test, TESTS.STSTest_definition, (Binding)Bindings.STRING);
        Integer priority = (Integer)graph.getPossibleRelatedValue(test, TESTS.STSTest_executionPriority, (Binding)Bindings.INTEGER);
        Boolean ignored = (Boolean)graph.getPossibleRelatedValue(test, TESTS.ignore, (Binding)Bindings.BOOLEAN);
        String dependencies = (String)graph.getPossibleRelatedValue(test, TESTS.dependencies, (Binding)Bindings.STRING);
        String[] actualDeps = dependencies.isEmpty() ? new String[]{} : dependencies.split(",");
        Collection stsVariables = graph.getObjects(test, L0.ConsistsOf);
        HashMap<String, String> variables = new HashMap<String, String>(stsVariables.size());
        for (Resource stsVariable : stsVariables) {
            String name = (String)graph.getRelatedValue(stsVariable, L0.HasName, (Binding)Bindings.STRING);
            String value = (String)graph.getRelatedValue(stsVariable, TESTS.STSVariable_definition);
            variables.put(name, value);
        }
        Resource parent = graph.getSingleObject(test, L0.PartOf);
        String possibleURI = graph.getPossibleURI(parent);
        String parentName = possibleURI != null ? possibleURI : (String)graph.getRelatedValue2(parent, L0.HasName, (Binding)Bindings.STRING);
        return new ModelledSTSTest(testName, parentName, code, priority != null ? priority : -1, ignored != null ? ignored : false, new HashSet<String>(Arrays.asList(actualDeps)), variables);
    }

    public static ModelledSTSSuite toModelledSuite(ReadGraph graph, Resource suite, List<ModelledSTSTest> children) throws DatabaseException {
        TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
        String suiteName = graph.getURI(suite);
        String moduleNameFilter = (String)graph.getPossibleRelatedValue2(suite, TESTS.STSSuite_moduleNameFilter, (Binding)Bindings.STRING);
        Integer priority = (Integer)graph.getPossibleRelatedValue2(suite, TESTS.STSTest_executionPriority, (Binding)Bindings.INTEGER);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection stsVariables = (Collection)graph.sync((ReadInterface)new ObjectsWithType(suite, L0.ConsistsOf, TESTS.STSVariable));
        HashMap<String, String> variables = new HashMap<String, String>(stsVariables.size());
        for (Resource stsVariable : stsVariables) {
            String name = (String)graph.getRelatedValue(stsVariable, L0.HasName, (Binding)Bindings.STRING);
            String value = (String)graph.getRelatedValue(stsVariable, TESTS.STSVariable_definition);
            variables.put(name, value);
        }
        return new ModelledSTSSuite(suiteName, children, moduleNameFilter, priority != null ? priority : -1, variables);
    }

    public static void setTestCoverage(ModelledSTSTest test, CommandSession session) {
        Collection runtimeModules = session.getRuntimeEnvironment().getRuntimeModules();
        ArrayList<Module> modules = new ArrayList<Module>(runtimeModules.size());
        for (RuntimeModule module : runtimeModules) {
            modules.add(module.getModule());
        }
        test.setCoverage(CoverageUtils.getCoverage(modules));
        CoverageUtils.resetCoverage(modules);
    }

    public static void setSuiteCoverage(ModelledSTSTest test, ModelledSTSSuite suite, CommandSession session) {
        Collection runtimeModules = session.getRuntimeEnvironment().getRuntimeModules();
        ArrayList<Module> modules = new ArrayList<Module>(runtimeModules.size());
        for (RuntimeModule module : runtimeModules) {
            for (Pattern p : suite.getModuleNameFilterPatterns()) {
                if (!p.matcher(module.getModule().getName().toLowerCase()).find()) continue;
                modules.add(module.getModule());
            }
        }
        test.setCoverage(CoverageUtils.getCoverage(modules));
        suite.addCoverage(modules);
        CoverageUtils.resetCoverage(modules);
    }
}

