/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.TestScriptExecutor;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.java.JavaModule;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.tests.modelled.utils.STSSuiteTestCollector;

public class ModelledSTSTest {
    private final String name;
    private final String parentName;
    private final String code;
    private final int priority;
    private final boolean ignored;
    private Set<String> dependencies;
    private Set<String> unresolvedDependencies;
    private CombinedCoverage coverage;
    private Map<String, String> variables;

    ModelledSTSTest(String name, String parentName, String code, int priority, boolean ignored, Set<String> dependencies, Map<String, String> variables) {
        this.name = name;
        this.parentName = parentName;
        this.code = code;
        this.priority = priority;
        this.ignored = ignored;
        this.dependencies = dependencies;
        this.unresolvedDependencies = new HashSet<String>(dependencies);
        this.variables = variables;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getCode() {
        return this.code;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isIgnored() {
        return this.ignored || !this.unresolvedDependencies.isEmpty();
    }

    public void setCoverage(CombinedCoverage coverage) {
        this.coverage = coverage;
    }

    public CombinedCoverage getCoverage() {
        return this.coverage;
    }

    public List<CommandSessionVariable> run(List<CommandSessionVariable> vars) throws IOException {
        ModuleRepository repo = SCLOsgi.MODULE_REPOSITORY;
        CommandSession session = null;
        try {
            SCLReportingHandler handler = (SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler");
            session = new CommandSession(repo, handler);
            for (CommandSessionVariable commandSessionVariable : vars) {
                session.setVariable(commandSessionVariable.getName(), commandSessionVariable.getType(), commandSessionVariable.getValue());
            }
            for (Map.Entry entry : this.variables.entrySet()) {
                session.setVariable((String)entry.getKey(), (Type)Types.STRING, entry.getValue());
            }
            new TestScriptExecutor(session, new BufferedReader(new StringReader(this.code)), handler, true).execute();
            STSSuiteTestCollector.setTestCoverage(this, session);
            ArrayList<CommandSessionVariable> arrayList = new ArrayList<CommandSessionVariable>();
            for (String var : session.getVariables()) {
                arrayList.add(new CommandSessionVariable(var, session.getVariableType(var), session.getVariableValue(var)));
            }
            ArrayList<CommandSessionVariable> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            Builtins.flush();
            JavaModule.flush();
        }
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    public boolean resolveDependency(String testDep) {
        return this.unresolvedDependencies.remove(testDep);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.coverage == null ? 0 : this.coverage.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        result = 31 * result + (this.ignored ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.unresolvedDependencies == null ? 0 : this.unresolvedDependencies.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelledSTSTest other = (ModelledSTSTest)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.coverage == null ? other.coverage != null : !this.coverage.equals(other.coverage)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.ignored != other.ignored) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.unresolvedDependencies == null ? other.unresolvedDependencies != null : !this.unresolvedDependencies.equals(other.unresolvedDependencies)) {
            return false;
        }
        return !(this.variables == null ? other.variables != null : !this.variables.equals(other.variables));
    }

    public static class CommandSessionVariable {
        private final String name;
        private final Type type;
        private final Object value;

        public CommandSessionVariable(String name, Type type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

