package org.simantics.tests.modelled.ui;

import java.io.IOException;
import java.util.List;

import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.ui.workbench.e4.E4WorkbenchUtils;

public class TestsUIUtils {

    private TestsUIUtils() {
    }

    public static void runSTSTestAction(Resource test) throws DatabaseException, IOException {
        MPart part = E4WorkbenchUtils.getMPartById(STSTestRunnerView.ID);
        E4WorkbenchUtils.openAndShowPart(part);
        Object obj = part.getObject();
        STSTestRunnerView view = (STSTestRunnerView) obj;
        view.currentTest(test);
        view.execute();
    }
    
    public static void ignoreSTSTestAction(List<Resource> tests) throws DatabaseException {
        Simantics.getSession().syncRequest(new Write() {
            
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                TestsResource TESTS = TestsResource.getInstance(graph);
                for (Resource test : tests) {
                    graph.claimLiteral(test, TESTS.ignore, true, Bindings.BOOLEAN);
                }
            }
        });
    }
}
