package org.simantics.tests.modelled.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.simantics.db.Resource;

public class STSTestSuiteProvider extends LabelProvider implements ITreeContentProvider, IStyledLabelProvider {

    private static final ImageDescriptor testIconDescriptor = Activator.getImageDescriptor("icons/test.png"); //$NON-NLS-1$
    private static final ImageDescriptor testOkIconDescriptor = Activator.getImageDescriptor("icons/testok.png"); //$NON-NLS-1$
    private static final ImageDescriptor testErrorIconDescriptor = Activator.getImageDescriptor("icons/testerr.png"); //$NON-NLS-1$
    private static final ImageDescriptor testFailIconDescriptor = Activator.getImageDescriptor("icons/testfail.png"); //$NON-NLS-1$
    private static final ImageDescriptor testRunningIconDescriptor = Activator.getImageDescriptor("icons/testrun.png"); //$NON-NLS-1$

    private static final ImageDescriptor suiteIconDescriptor = Activator.getImageDescriptor("icons/tsuite.png"); //$NON-NLS-1$
    private static final ImageDescriptor suiteOkIconDescriptor = Activator.getImageDescriptor("icons/tsuiteok.png"); //$NON-NLS-1$
    private static final ImageDescriptor suiteErrorIconDescriptor = Activator.getImageDescriptor("icons/tsuiteerror.png"); //$NON-NLS-1$
    private static final ImageDescriptor suiteFailIconDescriptor = Activator.getImageDescriptor("icons/tsuitefail.png"); //$NON-NLS-1$
    private static final ImageDescriptor suiteRunningIconDescriptor = Activator.getImageDescriptor("icons/tsuiterun.png"); //$NON-NLS-1$

    static Image testIcon;
    static Image testOkIcon;
    static Image testErrorIcon;
    static Image testFailIcon;
    static Image testRunningIcon;

    static Image suiteIcon;
    static Image suiteOkIcon;
    static Image suiteErrorIcon;
    static Image suiteFailIcon;
    static Image suiteRunningIcon;
    
    private STSTestSuiteModel model;
    
    public STSTestSuiteProvider(STSTestSuiteModel model) {
        this.model = model;
        testIcon = Activator.createManagedImage(testIconDescriptor);
        testOkIcon = Activator.createManagedImage(testOkIconDescriptor);
        testErrorIcon = Activator.createManagedImage(testErrorIconDescriptor);
        testFailIcon = Activator.createManagedImage(testFailIconDescriptor);
        testRunningIcon = Activator.createManagedImage(testRunningIconDescriptor);
        
        suiteIcon = Activator.createManagedImage(suiteIconDescriptor);
        suiteOkIcon = Activator.createManagedImage(suiteOkIconDescriptor);
        suiteErrorIcon = Activator.createManagedImage(suiteErrorIconDescriptor);
        suiteFailIcon = Activator.createManagedImage(suiteFailIconDescriptor);
        suiteRunningIcon = Activator.createManagedImage(suiteRunningIconDescriptor);
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return model.getElements();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        return model.getChildren(parentElement);
    }

    @Override
    public Object getParent(Object element) {
        return model.getParent(element);
    }

    @Override
    public boolean hasChildren(Object element) {
        return model.hasChildren(element);
    }

    @Override
    public StyledString getStyledText(Object element) {
        // TODO Auto-generated method stub
        return null;
    }
    
    @Override
    public String getText(Object element) {
        return model.getText(element);
    }
    
    @Override
    public Image getImage(Object element) {
        return model.getImage(element);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            if (!(newInput instanceof Resource))
                throw new IllegalArgumentException(newInput.toString());
            model.updateInput((Resource)newInput);
        }
    }

    public STSTestSuiteModel getModel() {
        return model;
    }

}
