package org.simantics.tests.modelled.ui;

import java.text.DecimalFormat;
import java.util.Collection;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.scl.compiler.module.coverage.Coverage;
import org.simantics.scl.compiler.module.coverage.FunctionCoverage;
import org.simantics.scl.compiler.module.coverage.ModuleCoverage;
import org.simantics.tests.modelled.ui.STSTestSuiteModel.STSSuite;
import org.simantics.tests.modelled.ui.STSTestSuiteModel.STSTest;

public class STSCoverageProvider extends LabelProvider implements ITreeContentProvider {

    private Object input;
    
    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        input = newInput;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        CombinedCoverage coverage;
        if (input instanceof STSTest) {
            STSTest test = (STSTest) input;
            coverage = test.getCoverage();
        } else if (input instanceof STSSuite) {
            STSSuite suite = (STSSuite) input;
            coverage = suite.getCoverage();
        } else {
            return new Object[0];
        }
        if (coverage == null)
            return new Object[0];
        
        return new Object[] { coverage };
        
//        Collection<ModuleCoverage> moduleCoverages = coverage.moduleCoverages.values();
//        return moduleCoverages.toArray(new ModuleCoverage[moduleCoverages.size()]);
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof CombinedCoverage) {
            CombinedCoverage coverage = (CombinedCoverage) parentElement;
            Collection<ModuleCoverage> moduleCoverages = coverage.moduleCoverages.values();
            return moduleCoverages.toArray(new ModuleCoverage[moduleCoverages.size()]);
        } else if (parentElement instanceof ModuleCoverage) {
            ModuleCoverage coverage = (ModuleCoverage) parentElement;
            Collection<FunctionCoverage> coverages = coverage.functionCoverages.values();
            return coverages.toArray(new FunctionCoverage[coverages.size()]);
        } else {
            return null;
        }
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof FunctionCoverage) {
            FunctionCoverage coverage = (FunctionCoverage) element;
            return new ModuleCoverage[] { null };
        } else {
            return null;
        }
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof CombinedCoverage)
            return !((CombinedCoverage) element).moduleCoverages.isEmpty();
        else if (element instanceof ModuleCoverage)
            return !((ModuleCoverage)element).functionCoverages.isEmpty();
        else
            return false;
    }
    
    @Override
    public String getText(Object element) {
        if (element instanceof Coverage)
            return ((Coverage) element).getIdentifier();
        return super.getText(element);
    }

    public String getRatio(Object element) {
        if (element instanceof Coverage)
            return formatPercentage(((Coverage) element).getCoverage());
        return "unknown " + element;
    }

    public String getCovered(Object element) {
        if (element instanceof Coverage)
            return ((Coverage) element).getCoveredCodeSize() + "";
        return "unknown " + element;
    }

    public String getMissed(Object element) {
        if (element instanceof Coverage)
            return ((Coverage) element).getMissedCodeSize() + "";
        return "unknown " + element;
    }

    public String getTotal(Object element) {
        if (element instanceof Coverage)
            return ((Coverage) element).getTotalCodeSize() + "";
        return "unknown " + element;
    }
    
    private static final DecimalFormat MAX_PERCENTAGE_STRING = new DecimalFormat("0.0 %");
    
    private static String formatPercentage(double perc) {
        return MAX_PERCENTAGE_STRING.format(perc);
    }

}
