/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.db.common.NamedResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.team.ui.StageInitWizard;
import org.simantics.utils.ui.ErrorLogger;

public class StageInitPage
extends WizardPage {
    final StageInitWizard.Data data;
    Text stagingFolder;
    CCombo teamFolder;
    List<Model> models = Collections.emptyList();
    Button overwrite;

    protected StageInitPage(StageInitWizard.Data data) {
        super("Staging", "Initialize", null);
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText("Workbench folder:");
        this.stagingFolder = new Text(container, 2048);
        this.stagingFolder.setEditable(false);
        this.stagingFolder.setText(this.data.stagingFolder.getAbsolutePath());
        this.stagingFolder.setToolTipText("Shows the folder of the staging workbench.");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.stagingFolder);
        new Label(container, 0).setText("&Team folder:");
        this.teamFolder = new CCombo(container, 2048);
        if (this.data.teamFolder != null) {
            this.teamFolder.setText(this.data.teamFolder.getAbsolutePath());
        }
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.teamFolder);
        this.teamFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StageInitPage.this.validatePage();
            }
        });
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("B&rowse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(StageInitPage.this.getShell(), 4096);
                dd.setText("Choose team folder");
                File folder = new File(StageInitPage.this.teamFolder.getText());
                if (folder.isDirectory()) {
                    dd.setFilterPath(folder.getAbsolutePath());
                } else if ((folder = folder.getParentFile()) != null && folder.isDirectory()) {
                    dd.setFilterPath(folder.getParent());
                } else if (StageInitPage.this.data.teamFolder != null && StageInitPage.this.data.teamFolder.isDirectory()) {
                    dd.setFilterPath(StageInitPage.this.data.teamFolder.getAbsolutePath());
                } else {
                    String temp = System.getProperty("java.io.tmpdir");
                    if (temp != null && !temp.equals("")) {
                        dd.setFilterPath(temp);
                    }
                }
                String dir = dd.open();
                if (dir == null) {
                    return;
                }
                StageInitPage.this.teamFolder.setText(dir);
                StageInitPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        for (String path : this.data.recentLocations) {
            this.teamFolder.add(path);
        }
        if (this.teamFolder.getItemCount() > 0) {
            this.teamFolder.select(0);
        }
    }

    void validatePage() {
        String importLoc = this.teamFolder.getText();
        if (importLoc.isEmpty()) {
            this.setMessage("Select folder for team data.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File folder = new File(importLoc);
        if (!folder.exists() || !folder.isDirectory()) {
            this.setErrorMessage("Selected folder is invalid.");
            this.setPageComplete(false);
            return;
        }
        int count = folder.list().length;
        if (!this.data.requireExisting.booleanValue()) {
            if (count > 0) {
                this.setErrorMessage("Selected folder is not empty.");
                this.setPageComplete(false);
                return;
            }
        } else if (count == 0) {
            this.setErrorMessage("Selected folder is not team folder.");
            this.setPageComplete(false);
            return;
        }
        this.data.teamFolder = folder;
        this.data.comment = "Initial commit.";
        this.setErrorMessage(null);
        this.setMessage("Stage " + folder.getAbsolutePath() + ".");
        this.setPageComplete(true);
    }

    public static class Model
    implements Comparable<Model> {
        NamedResource model;

        public Model(NamedResource model) {
            this.model = model;
        }

        @Override
        public int compareTo(Model o) {
            return this.model.compareTo(o.model);
        }

        public NamedResource get() {
            return this.model;
        }
    }
}

