/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.nodes;

import org.simantics.db.Resource;

public class ConnectionNode {

    public final Resource connection;
    public final Resource composite;

    public ConnectionNode(Resource connection, Resource composite) {
        this.connection = connection;
        this.composite = composite;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((composite == null) ? 0 : composite.hashCode());
        result = prime * result
                + ((connection == null) ? 0 : connection.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ConnectionNode other = (ConnectionNode) obj;
        if (composite == null) {
            if (other.composite != null)
                return false;
        } else if (!composite.equals(other.composite))
            return false;
        if (connection == null) {
            if (other.connection != null)
                return false;
        } else if (!connection.equals(other.connection))
            return false;
        return true;
    }

}
