package org.simantics.structural.ui.modelBrowser.contributions;

import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * @author Tuukka Lehtonen
 */
public enum ExperimentLabelRule implements LabelRule {

    INSTANCE;

    public static ExperimentLabelRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Resource experiment = (Resource) content;

        String name = LabelerUtil.safeStringRepresentation(graph, experiment);
        Resource initialState = graph.getPossibleObject(experiment, SimulationResource.getInstance(graph).HasInitialState);
        if (initialState != null)
            name += " (" + LabelerUtil.safeStringRepresentation(graph, initialState) + ")";
        return ArrayMap.make(ColumnKeys.KEYS_SINGLE, new String[] { name });
    }

}
