/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JTable;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.ui.TextTableCellEditor;

public class TableDropTargetListener
implements DropTargetListener {
    JTable table;
    Adaptable model;
    ClientModel clientModel;

    public TableDropTargetListener(JTable table, Adaptable model, ClientModel clientModel) {
        this.table = table;
        this.model = model;
        this.clientModel = clientModel;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable tr = dropTargetDropEvent.getTransferable();
        if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                String cfr_ignored_0 = (String)tr.getTransferData(DataFlavor.stringFlavor);
                Point point = dropTargetDropEvent.getLocation();
                int row = this.table.rowAtPoint(point);
                int column = this.table.columnAtPoint(point);
                CellEditor e = (CellEditor)this.model.getAdapter(CellEditor.class);
                TextTableCellEditor editor = new TextTableCellEditor(row, column, "", e, this.clientModel);
                editor.commit();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

