/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;
import org.simantics.ui.colors.Colors;

public class SheetBorder
extends EmptyBorder {
    private static final long serialVersionUID = 1L;
    protected boolean bottomColor;
    protected boolean rightColor;
    final Color NONE = Colors.awt((org.simantics.common.color.Color)Colors.rgb((double)0.9, (double)0.9, (double)0.9));

    public SheetBorder(int top, int left, int bottom, int right, boolean bottomColor, boolean rightColor) {
        super(top, left, bottom, right);
        this.bottomColor = bottomColor;
        this.rightColor = rightColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        boolean same;
        Insets insets = this.getBorderInsets(c);
        Color oldColor = g.getColor();
        g.translate(x, y);
        boolean bl = same = this.bottomColor == this.rightColor;
        if (same) {
            g.setColor(this.bottomColor ? Color.BLACK : this.NONE);
            g.fillRect(0, height - insets.bottom, 2 + width - insets.left, insets.bottom);
            g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom + 2);
        } else if (this.bottomColor) {
            g.setColor(this.NONE);
            g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom + 2);
            g.setColor(Color.BLACK);
            g.fillRect(0, height - insets.bottom, 2 + width - insets.left, insets.bottom);
        } else {
            g.setColor(this.NONE);
            g.fillRect(0, height - insets.bottom, 2 + width - insets.left, insets.bottom);
            g.setColor(Color.BLACK);
            g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom + 2);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.computeInsets(insets);
    }

    @Override
    public Insets getBorderInsets() {
        return this.computeInsets(new Insets(0, 0, 0, 0));
    }

    private Insets computeInsets(Insets insets) {
        insets.left = this.left;
        insets.top = this.top;
        insets.right = this.right;
        insets.bottom = this.bottom;
        return insets;
    }

    public Color getMatteColor() {
        return this.NONE;
    }

    public Icon getTileIcon() {
        return null;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

