/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet;


public class Range {
	public static final int MAXROWSPEC = Integer.MAX_VALUE;//1048576;//
	public static final int MAXCOLUMNSPEC = Integer.MAX_VALUE;//16384;//
	
    public int startRow;
    public int endRow;
    public int startColumn;
    public int endColumn;
    
    public Range(int startRow, int endRow, int startColumn, int endColumn) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        
        if(startRow == -1) this.startRow = MAXROWSPEC;
    	if(endRow == -1) this.endRow = MAXROWSPEC;
    	if(startColumn == -1) this.startColumn = MAXCOLUMNSPEC;
    	if(endColumn == -1) this.endColumn = MAXCOLUMNSPEC;
    }
    
    public Range(Range copy) {
        this.startRow = copy.startRow;
        this.endRow = copy.endRow;
        this.startColumn = copy.startColumn;
        this.endColumn = copy.endColumn;
    }

    public static Range combine(Range from, Range to) {
        return new Range(from.startRow, to.endRow, from.startColumn, to.endColumn);
    }
    
    public boolean isFull() {
    	return endRow == MAXROWSPEC && endColumn == MAXCOLUMNSPEC;
    }

    public boolean isFullRows() {
    	return endRow == MAXROWSPEC;
    }

    public boolean isFullColumns() {
    	return endColumn == MAXCOLUMNSPEC;
    }

    public int size() {
        return (endRow-startRow + 1) * (endColumn - startColumn + 1);
    }
    
    public int width() {
    	return (endColumn - startColumn + 1);
    }
    
    public int height() {
    	return (endRow-startRow + 1);
    }
    
    public boolean contains(Range r) {
    	if(endRow >= 0) {
        	if(r.endRow > endRow) return false;
    		if(r.startRow < startRow) return false;
    	}
    	if(endColumn >= 0) {
    		if(r.startColumn < startColumn) return false;
    		if(r.endColumn > endColumn) return false;
    	}
    	return true;
    }
    
    @Override
    public String toString() {
        return "Range[(" + startRow + "," + startColumn + ")-(" + endRow + "," + endColumn + ")]";
    }
    
}
