package org.simantics.spreadsheet.graph.synchronization;

import java.io.Serializable;

import org.simantics.structural.synchronization.utils.ComponentBase;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;

public class SheetLineComponent extends ComponentBase<SheetLineComponent> implements Serializable {

    private static final long serialVersionUID = 1777515716175831266L;
    
	private THashMap<String, SheetLineComponent> childMap = new THashMap<>();
	
	public SheetLineComponent(String uid) {
	    super(uid, 0);
	}
	
//	public SheetLineComponent(String uid, String solverComponentName, int componentId) {
//		this.uid = uid;
//		this.solverComponentName = solverComponentName;
//		this.componentId = componentId;
//	}
	
	@Override
	public THashMap<String, SheetLineComponent> getChildMap() {
		return childMap;
	}

	@Override
	public void setChildMap(THashMap<String, SheetLineComponent> newChildMap) {
		childMap = newChildMap;
		if(childMap != null) {
			childMap.forEachValue(new TObjectProcedure<SheetLineComponent>() {
				@Override
				public boolean execute(SheetLineComponent component) {
					component.parent = SheetLineComponent.this;
					return true;
				}
			});
		}
	}
	
	@Override
	public String toString() {
	    return solverComponentName + " (" + super.toString() + ")";
	}

}
