/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph.parser.ast;

public class AstRelation implements AstValue {

	public AstValue left;
	public String op;
	public AstValue right;

	public AstRelation(AstValue left) {
		this.left = left;
	}
	
	public void setRight(String op, AstValue right) {
		this.op = op.trim();
		this.right = right;
	}
	
	@Override
	public <T> T accept(AstValueVisitor<T> v) {
		return v.visit(this);
	}

	public AstValue simplify() {
		if(right == null) return left;
		else return this;
	}
	
}
