package org.simantics.spreadsheet.graph.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.ExtendedGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.SheetVariables;
import org.simantics.spreadsheet.common.matrix.VariantMatrix;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class SpreadsheetVariable extends ExtendedGraphChildVariable {

//    final private Collection<Pair<StringCellParser, GraphCellCreator>> creators = new ArrayList<Pair<StringCellParser, GraphCellCreator>>(); 
	
	public SpreadsheetVariable(Variable parent, Resource resource) throws DatabaseException {
		
		super(parent, resource);
		
//	    creators.add(new Pair<StringCellParser, GraphCellCreator>(Parsers.MATRIX_PARSER, new MatrixCellCreator(resource)));
//	    creators.add(new Pair<StringCellParser, GraphCellCreator>(Parsers.EXPRESSION_PARSER, new ExpressionCellCreator(resource)));
//	    creators.add(new Pair<StringCellParser, GraphCellCreator>(Parsers.COMMAND_PARSER, new CommandCellCreator(resource)));
//	    creators.add(new Pair<StringCellParser, GraphCellCreator>(Parsers.RESOURCE_ARRAY_PARSER, new ResourceArrayCellCreator(resource)));
//	    creators.add(new Pair<StringCellParser, GraphCellCreator>(Parsers.TEXT_PARSER, new TextCellCreator(resource)));
	    
	}
	
    @SuppressWarnings("unchecked")
    protected <T> T tryAdapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
		if(VariableSpaceManipulator.class == clazz) {
			
			return (T)new VariableSpaceManipulator() {

				@Override
				public void apply(WriteGraph graph, Modification modification) throws DatabaseException {
					
					Layer0 L0 = Layer0.getInstance(graph);
					for(String name : modification.removedChildren) {
						Variable child = getChild(graph, name);
						Resource represents = child.getRepresents(graph);
						graph.deny(represents, L0.PartOf);
					}
					
					for(ChildCreationData data : modification.newChildren) {
						Resource container = getRepresents(graph);
						Resource cell = graph.newResource();
						Resource type = graph.getResource(data.type);
						graph.claim(cell, L0.InstanceOf, null, type);
						graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, data.name, Bindings.STRING);
						for(PropertyCreationData p : data.properties) {
							Resource property = graph.getResource(p.name);
							graph.claimLiteral(cell, property, p.value.getValue());
						}
						graph.claim(cell, L0.PartOf, container);
						
					}
					
				}
				
			};
			
		}
		return null;
	}

	@Override
	public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
		T t = tryAdapt(graph, clazz);
		return t != null ? t : super.adapt(graph, clazz);
	}

	@Override
	public <T> T adaptPossible(ReadGraph graph, Class<T> clazz) throws DatabaseException {
		T t = tryAdapt(graph, clazz);
		return t != null ? t : super.adaptPossible(graph, clazz);
	}

	final String[] propertyNames = { SheetVariables.CONTENT, Variables.LABEL, "immutable" }; 
	final Binding[] bindings = { Bindings.VARIANT, Bindings.STRING, Bindings.BOOLEAN};
	
	@Override
	public Variable getPossibleSpecialChild(ReadGraph graph, String name) throws DatabaseException {
		if(name.contains(":")) {
			Range range = SpreadsheetUtils.decodeRange(name, 0, 0);
			
			VariantMatrix matrix = new VariantMatrix(range.height(),range.width());
			
			for(int x=range.startColumn;x<=range.endColumn;x++) {
				for(int y=range.startRow;y<=range.endRow;y++) {
					String location = SpreadsheetUtils.cellName(y,x);
					Variable child = getPossibleChild(graph, location);
					Variant value = null;
					if(child != null)
					    value = child.getPossiblePropertyValue(graph, SheetVariables.CONTENT, Bindings.VARIANT);
					matrix.set(y-range.startRow, x-range.startColumn, value);
				}
			}
			
			return new ConstantChildVariable(this, name, propertyNames, bindings, new Object[] {
					Variant.ofInstance(matrix), null, name, false
			});
			
		} else {
			return super.getPossibleSpecialChild(graph, name);
		}
	}
	
}
