package org.simantics.spreadsheet.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class SpreadsheetStates extends VariableRead<Map<String, Resource>> {

    public SpreadsheetStates(Variable variable) {
        super(variable);
    }

    @Override
    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        Resource book = variable.getParent(graph).getRepresents(graph);
        Layer0 L0 = Layer0.getInstance(graph);
        Collection<Resource> states = graph.syncRequest(new ObjectsWithType(book, L0.ConsistsOf, SpreadsheetResource.getInstance(graph).InitialCondition));
        Map<String, Resource> result = new HashMap<>(states.size());
        states.forEach(state -> {
            try {
                String name = graph.getPossibleRelatedValue(state, L0.HasName, Bindings.STRING);
                result.put(name, state);
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        return result;
        
    }

}
