package org.simantics.spreadsheet.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class SpreadsheetLine implements SpreadsheetElement<SpreadsheetCell, SpreadsheetLines>, SheetNode {

	private static final long serialVersionUID = -304574098117404663L;
	
	final private SpreadsheetLines parent;
	final public int row;
	int id;
	
	public ObjectArrayList<SpreadsheetCell> cells = new ObjectArrayList<>();
	
	public SpreadsheetLine(SpreadsheetLines parent, int row) {
		this.parent = parent;
		this.row = row;
		this.id = getEngine().getBook().getNewId(this);
//		getEngine().registerRow(row, this);
	}
	
	public int getId() {
		return id;
	}
	
	public SpreadsheetEngine getEngine() {
//		if(parent instanceof SpreadsheetEngine)
//		    return (SpreadsheetEngine)parent;
		return ((SpreadsheetLines)parent).getEngine();
	}

	@Override
	public String getName() {
		return "Row"+row;
	}

	@Override
	public Map getChildren() {
		String rowName = ""+row;
		Map<String,SpreadsheetCell> result = new HashMap<>();
		for(int i=0;i<cells.size();i++) {
			SpreadsheetCell cell = cells.get(i);
			if(SpreadsheetCell.EMPTY == cell) continue;
			String name = "Row"+SpreadsheetUtils.columnName(i) + rowName;
			result.put(name, cell);
		}
		return result;
	}

	@Override
	public Map getProperties() {
		return Collections.singletonMap("typeURI", new SpreadsheetTypeNode(SpreadsheetResource.URIs.Line));
	}
	
	Object resolve(String[] parts, int index) {
		
		if(index == parts.length) return this;
		
		Range r = SpreadsheetUtils.decodeCellAbsolute(parts[index]);
		return cells.get(r.startColumn);
		
	}

	public void accept(SpreadsheetVisitor v) {
		v.visit(this);
	}
	
	public String getPath() {
		return ((SpreadsheetLines)parent).getPath() + "/" + getName();
	}

    @Override
    public Optional<SpreadsheetLines> getParent() {
        return Optional.of(parent);
    }

    @Override
    public List<SpreadsheetCell> getSpreadsheetChildren() {
        return cells;
    }

    @Override
    public void remove(SpreadsheetCell child) {
        
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((parent == null) ? 0 : parent.hashCode());
        result = prime * result + row;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SpreadsheetLine other = (SpreadsheetLine) obj;
        if (parent == null) {
            if (other.parent != null)
                return false;
        } else if (!parent.equals(other.parent))
            return false;
        if (row != other.row)
            return false;
        return true;
    }

}
