/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;

abstract public class ServerCellBase implements ServerCell {

    protected boolean disposed = false;

    protected RequestProcessor processor;
    protected RequestProcessor delayed;
    protected Resource resource;

    @Override
    public void register(RequestProcessor processor, RequestProcessor delayed, Resource cell) {
        this.processor = processor;
        this.delayed = delayed;
        this.resource = cell;
    }

    @Override
    public void dispose() {
        disposed = true;
    }

    public Resource getResource() {
        return resource;
    }

}
