/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.common;

import org.simantics.document.server.io.IColor;
import org.simantics.document.server.io.IFont;
import org.simantics.document.server.io.ITableCell;

public class TableCell
implements ITableCell {
    public int column;
    public int row;
    public int border;
    public int align;
    public String text;
    public IFont font;
    public IColor foreground;
    public IColor background;
    public boolean locked;
    public int rowSpan = 1;
    public int columnSpan = 1;

    public TableCell() {
    }

    public TableCell(int column, int row, int border, int align, String text, IFont font, IColor foreground, IColor background, boolean locked, int rowSpan, int columnSpan) {
        this.column = column;
        this.row = row;
        this.border = border;
        this.align = align;
        this.text = text;
        this.font = font;
        this.foreground = foreground;
        this.background = background;
        this.locked = locked;
        this.rowSpan = rowSpan;
        this.columnSpan = columnSpan;
    }

    public TableCell(ITableCell other) {
        this(other.getColumn(), other.getRow(), other.getBorder(), other.getAlign(), other.getText(), other.getFont(), other.getFGColor(), other.getBGColor(), other.getLocked(), other.getRowSpan(), other.getColumnSpan());
    }

    public String getText() {
        return this.text;
    }

    public int getColumn() {
        return this.column;
    }

    public int getBorder() {
        return this.border;
    }

    public int getAlign() {
        return this.align;
    }

    public int getRow() {
        return this.row;
    }

    public IFont getFont() {
        return this.font;
    }

    public IColor getFGColor() {
        return this.foreground;
    }

    public IColor getBGColor() {
        return this.background;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.align;
        result = 31 * result + (this.background == null ? 0 : this.background.hashCode());
        result = 31 * result + this.border;
        result = 31 * result + this.column;
        result = 31 * result + this.columnSpan;
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + (this.foreground == null ? 0 : this.foreground.hashCode());
        result = 31 * result + (this.locked ? 1231 : 1237);
        result = 31 * result + this.row;
        result = 31 * result + this.rowSpan;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableCell other = (TableCell)obj;
        if (this.align != other.align) {
            return false;
        }
        if (this.background == null ? other.background != null : !this.background.equals(other.background)) {
            return false;
        }
        if (this.border != other.border) {
            return false;
        }
        if (this.column != other.column) {
            return false;
        }
        if (this.columnSpan != other.columnSpan) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        if (this.foreground == null ? other.foreground != null : !this.foreground.equals(other.foreground)) {
            return false;
        }
        if (this.locked != other.locked) {
            return false;
        }
        if (this.row != other.row) {
            return false;
        }
        if (this.rowSpan != other.rowSpan) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

