/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.simulator.toolkit.db;

import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.simulator.toolkit.StandardNodeManager;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Adds support for Layer0 Variable interface in StandardNodeManager
 *
 * @author Antti Villberg
 */
public class StandardVariableNodeManager<Node, Engine extends StandardNodeManagerSupport<Node>> extends StandardNodeManager<Node,Engine> {

    private static final Logger LOGGER = LoggerFactory.getLogger(StandardVariableNodeManager.class); 
    protected NodeSupport<Node> support;

    public StandardVariableNodeManager(StandardRealm<Node, Engine> realm, Node root) {
        super(realm, root);
        this.support = new NodeSupport<>(this);
    }

/*    public void registerNodeSupport(NodeSupport<Node> support) {
        this.support = support;
    }


    public void registerSupport(NodeSupport<Node> support) {
        this.support = support;
    }*/

    @Override
    public void refreshVariable(Node node) {
        try {
            support.refreshCache(node);
        } catch (NodeManagerException e) {
            LOGGER.error("Failed to refresh variable", e);
            throw new RuntimeException(e);
        }
        super.refreshVariable(node);
    }

}