/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.modulebrowser;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Iterator;

public class ModuleNameTreeEntry
implements Comparable<ModuleNameTreeEntry> {
    public static final String STANDARD_LIBRARY = "StandardLibrary";
    public static final String HTTP_PREFIX = "http://";
    public final ModuleNameTreeEntry parent;
    public final String fullName;
    public final String name;
    public final THashMap<String, ModuleNameTreeEntry> childMap = new THashMap();
    public boolean isModule;

    public ModuleNameTreeEntry(ModuleNameTreeEntry parent, String fullName, String name) {
        this.parent = parent;
        this.fullName = fullName;
        this.name = name;
    }

    public void addModule(String moduleFullName) {
        int startingPos = this.fullName.isEmpty() ? 0 : this.fullName.length() + 1;
        int p = this.parent == null && moduleFullName.startsWith(HTTP_PREFIX) ? moduleFullName.indexOf(47, HTTP_PREFIX.length()) : moduleFullName.indexOf(47, startingPos);
        if (p == -1) {
            if (this.parent == null) {
                this.getOrCreateChildMapEntry(STANDARD_LIBRARY).addModule(this.name);
            } else {
                String name = moduleFullName.substring(startingPos);
                ModuleNameTreeEntry entry = this.getOrCreateChildMapEntry(name);
                entry.isModule = true;
            }
        } else {
            String name = moduleFullName.substring(startingPos, p);
            ModuleNameTreeEntry entry = this.getOrCreateChildMapEntry(name);
            entry.addModule(moduleFullName);
        }
    }

    private ModuleNameTreeEntry getOrCreateChildMapEntry(String name) {
        ModuleNameTreeEntry entry = (ModuleNameTreeEntry)this.childMap.get((Object)name);
        if (entry == null) {
            String newFullName = this.parent == null ? (name.equals(STANDARD_LIBRARY) ? "" : name) : String.valueOf(this.fullName) + "/" + name;
            entry = new ModuleNameTreeEntry(this, newFullName, name);
            this.childMap.put((Object)name, (Object)entry);
        }
        return entry;
    }

    public Object[] children() {
        Object[] result = this.childMap.values().toArray();
        Arrays.sort(result);
        return result;
    }

    public void clearModuleFlags() {
        this.isModule = false;
        for (ModuleNameTreeEntry child : this.childMap.values()) {
            child.clearModuleFlags();
        }
    }

    @Override
    public int compareTo(ModuleNameTreeEntry o) {
        return this.name.compareTo(o.name);
    }

    public boolean prune() {
        Iterator it = this.childMap.values().iterator();
        while (it.hasNext()) {
            ModuleNameTreeEntry entry = (ModuleNameTreeEntry)it.next();
            if (entry.prune()) continue;
            it.remove();
        }
        return this.isModule || !this.childMap.isEmpty();
    }
}

