/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.completions.parsing;

import java.io.Reader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.compilation.DeclarationClassification;
import org.simantics.scl.compiler.completions.parsing.ModuleSegment;
import org.simantics.scl.compiler.completions.parsing.RobustModuleSplitter;
import org.simantics.scl.compiler.completions.parsing.SubstringReader;
import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserOptions;

public class RobustModuleParser {
    private static List<DeclarationAst> parseSegment(CompilationContext context, AtomicBoolean firstToken, Reader reader) {
        SCLParserImpl parser = new SCLParserImpl(reader);
        parser.getLexer().isFirstToken = firstToken.get();
        parser.setCompilationContext(context);
        parser.setParserOptions(SCLParserOptions.MODULE_DEFAULT);
        List result = (List)parser.parseModule();
        firstToken.set(parser.getLexer().isFirstToken);
        return result;
    }

    public static DeclarationClassification parse(CompilationContext context, String sourceText) {
        DeclarationClassification declarations = new DeclarationClassification(context);
        AtomicBoolean firstToken = new AtomicBoolean(false);
        for (ModuleSegment segment : RobustModuleSplitter.split(sourceText)) {
            if (segment.hasErrors) {
                System.out.println("    has errors");
                continue;
            }
            SubstringReader reader = new SubstringReader(sourceText, segment.begin, segment.end);
            try {
                for (DeclarationAst declaration : RobustModuleParser.parseSegment(context, firstToken, reader)) {
                    declarations.handle(declaration);
                }
            }
            catch (Exception exception) {}
        }
        return declarations;
    }
}

