package org.simantics.scl.commands.internal.checker;

import java.util.List;

import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.function.Function;

public class FunctionCheckItem implements CheckItem {

    Type parameterType;
    CheckItem next;
    
    public FunctionCheckItem(Type parameterType, CheckItem next) {
        this.parameterType = parameterType;
        this.next = next;
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public boolean check(Object check, Object[] parameters, int pos) {
        if(pos == parameters.length)
            return true;
        Object nextCheck = ((Function)check).apply(parameters[pos]);
        return next.check(nextCheck, parameters, pos+1);
    }

    @Override
    public void collectParameterTypes(List<Type> types) {
        types.add(parameterType);
        next.collectParameterTypes(types);
    }

}
