/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import com.kitfox.svg.SVGDiagram;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.simantics.scenegraph.utils.BufferedImage;

public class MipMapBufferedImage
extends BufferedImage {
    public static final double MARGIN_PERCENT = 3.0;
    public static final double MAX_DIMENSION = 600.0;
    public static final double MIN_DIMENSION = 4.0;
    Map<Double, IRaster> rasters = new HashMap<Double, IRaster>();
    double[] resolutions;
    double minResolution;
    double maxResolution;

    public MipMapBufferedImage(SVGDiagram original, Rectangle2D imageBounds, Point referenceSize) {
        super(original, imageBounds, referenceSize);
        this.initializeRasters();
    }

    /*
     * Unable to fully structure code
     */
    private void initializeRasters() {
        block6: {
            block4: {
                block5: {
                    resolutions = new ArrayList<Double>();
                    if (this.referenceSize == null || this.imageBounds.isEmpty()) break block4;
                    maxResolution = this.maxResolution();
                    minResolution = this.minResolution();
                    resolution = fitResolution = this.fitResolution(this.referenceSize);
                    while (!((next = resolution * 2.0) > maxResolution)) {
                        resolution = next;
                    }
                    break block5;
lbl10:
                    // 1 sources

                    while (true) {
                        r = this.createRaster(resolution);
                        this.rasters.put(resolution, r);
                        resolutions.add(resolution);
                        resolution /= 2.0;
                        break;
                    }
                }
                ** while (resolution > minResolution)
lbl19:
                // 1 sources

                break block6;
            }
            maxResolution = this.maxResolution();
            minResolution = this.minResolution();
            resolution = maxResolution;
            while (resolution > minResolution) {
                r = this.createRaster(resolution);
                this.rasters.put(resolution, r);
                resolutions.add(resolution);
                resolution /= 2.0;
            }
        }
        this.resolutions = new double[resolutions.size()];
        i = 0;
        while (i < resolutions.size()) {
            this.resolutions[i] = (Double)resolutions.get(resolutions.size() - 1 - i);
            ++i;
        }
        this.minResolution = this.resolutions[0];
        this.maxResolution = this.resolutions[this.resolutions.length - 1];
    }

    protected IRaster createRaster(double resolution) {
        return new BufferedRaster(resolution);
    }

    private double fitResolution(Point p) {
        double wid = this.imageBounds.getWidth();
        double hei = this.imageBounds.getHeight();
        double rx = (double)p.x / wid;
        double ry = (double)p.y / hei;
        return Math.min(rx, ry);
    }

    private double maxResolution() {
        double wid = this.imageBounds.getWidth();
        double hei = this.imageBounds.getHeight();
        return 600.0 / Math.sqrt(wid * hei);
    }

    private double minResolution() {
        double wid = this.imageBounds.getWidth();
        double hei = this.imageBounds.getHeight();
        return 4.0 / Math.sqrt(wid * hei);
    }

    protected double requiredResolution(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        double sx = Math.sqrt(m00 * m00 + m10 * m10);
        double sy = Math.sqrt(m01 * m01 + m11 * m11);
        return Math.max(sx, sy);
    }

    protected double findClosestResolution(double resolution) {
        int index = Arrays.binarySearch(this.resolutions, resolution);
        if (index >= 0) {
            return this.resolutions[index];
        }
        if ((index = -(index + 1)) >= this.resolutions.length) {
            index = this.resolutions.length - 1;
        }
        if (index < 0) {
            index = 0;
        }
        return this.resolutions[index];
    }

    @Override
    public void paint(Graphics2D g) {
        if (g.getRenderingHint(RenderingHints.KEY_RENDERING) == RenderingHints.VALUE_RENDER_QUALITY) {
            try {
                this.source.render(g);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        double requiredResolution = this.requiredResolution(g.getTransform());
        if ((requiredResolution *= 0.95) > this.getRasterRenderingThresholdResolution()) {
            Graphics2D g2d = (Graphics2D)g.create();
            this.setupSourceRender(g2d);
            try {
                try {
                    this.source.render(g2d);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    g2d.dispose();
                }
            }
            finally {
                g2d.dispose();
            }
        } else {
            Object origInterpolationHint = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (origInterpolationHint == null) {
                origInterpolationHint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            double closestResolution = this.findClosestResolution(requiredResolution);
            IRaster raster = this.rasters.get(closestResolution);
            try {
                raster.paint(g);
            }
            finally {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, origInterpolationHint);
            }
        }
    }

    protected void setupSourceRender(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
    }

    protected double getRasterRenderingThresholdResolution() {
        return this.maxResolution;
    }

    @Override
    public synchronized void releaseRaster() {
        for (IRaster r : this.rasters.values()) {
            r.release();
        }
    }

    class BufferedRaster
    extends Raster {
        java.awt.image.BufferedImage image;
        int wid;
        int hei;

        BufferedRaster(double resolution) {
            super(resolution);
            double wid = MipMapBufferedImage.this.imageBounds.getWidth();
            double hei = MipMapBufferedImage.this.imageBounds.getHeight();
            this.wid = (int)(wid * resolution);
            this.hei = (int)(hei * resolution);
        }

        synchronized java.awt.image.BufferedImage getOrCreate() {
            if (this.image != null) {
                return this.image;
            }
            this.image = new java.awt.image.BufferedImage(this.wid + 0 + 1, this.hei + 0 + 1, 2);
            Graphics2D target = this.image.createGraphics();
            target.setBackground(new Color(255, 255, 255, 0));
            target.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
            target.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            target.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            target.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            target.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            target.scale(this.resolution, this.resolution);
            target.translate(-MipMapBufferedImage.this.imageBounds.getMinX(), -MipMapBufferedImage.this.imageBounds.getMinY());
            try {
                MipMapBufferedImage.this.source.render(target);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            target.dispose();
            return this.image;
        }

        @Override
        public void paint(Graphics2D g) {
            java.awt.image.BufferedImage image = this.getOrCreate();
            if (image == null) {
                try {
                    MipMapBufferedImage.this.source.render(g);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            AffineTransform af = g.getTransform();
            Object rh = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            try {
                if (rh == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                g.translate(MipMapBufferedImage.this.imageBounds.getMinX(), MipMapBufferedImage.this.imageBounds.getMinY());
                g.scale(1.0 / this.resolution, 1.0 / this.resolution);
                g.drawImage((Image)image, 0, 0, null);
            }
            finally {
                g.setTransform(af);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, rh);
            }
        }

        @Override
        public void release() {
            this.image = null;
        }
    }

    static interface IRaster
    extends Comparable<IRaster> {
        public double getResolution();

        public void paint(Graphics2D var1);

        public void release();
    }

    static abstract class Raster
    implements IRaster {
        protected final double resolution;

        public Raster(double resolution) {
            this.resolution = resolution;
        }

        @Override
        public double getResolution() {
            return this.resolution;
        }

        @Override
        public int compareTo(IRaster o) {
            double r = this.getResolution();
            double or = o.getResolution();
            if (or < r) {
                return -1;
            }
            if (or > r) {
                return 1;
            }
            return 0;
        }
    }
}

