/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;

public class BoundsNode
extends G2DNode {
    private static final long serialVersionUID = -3215912248617879834L;
    private Rectangle2D controlbounds = new Rectangle();
    private ResizeListener resizeListener = null;

    @INode.SyncField(value={"controlbounds"})
    protected void setControlBounds(Rectangle2D r) {
        this.controlbounds = r.getBounds2D();
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public Rectangle2D getControlBounds() {
        return this.controlbounds;
    }

    @Override
    public void render(Graphics2D g2d) {
        Rectangle2D r = (Rectangle2D)g2d.getRenderingHint(G2DRenderingHints.KEY_CONTROL_BOUNDS);
        if (r != null && !r.equals(this.controlbounds)) {
            this.setControlBounds(r);
            this.controlResized(r);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [controlbounds=" + this.controlbounds + "]";
    }

    public void setResizeListener(ResizeListener listener) {
        this.resizeListener = listener;
    }

    @INode.ServerSide
    public void controlResized(Rectangle2D bounds) {
        if (this.resizeListener != null && bounds != null) {
            this.resizeListener.controlResized(bounds);
        }
    }

    public static interface ResizeListener {
        public void controlResized(Rectangle2D var1);
    }
}

