/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.utils;

import java.awt.GraphicsConfiguration;
import java.awt.image.VolatileImage;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author Antti Villberg
 */
public interface VolatileImageProvider {

    /**
     * @param gc
     * @param createdNew set to <code>true</code> if the provider created a new
     *        VolatileImage or <code>false</code> if a previously cached image
     *        is returned. A <code>null</code> value will simply be ignored.
     * @return
     */
    VolatileImage get(GraphicsConfiguration gc, AtomicInteger validateResult);

    void dispose();

}
