/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes.connection;

import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.delta.RouteGraphDelta;

/**
 * @author Tuukka Lehtonen
 * 
 * @see RouteGraphNode
 * @see IRouteGraphListener
 */
public class RouteGraphChangeEvent {

    public final RouteGraphNode node;
    public final RouteGraph before;
    public final RouteGraph after;
    public final RouteGraphDelta delta;

    public RouteGraphChangeEvent(RouteGraphNode node, RouteGraph before, RouteGraph after, RouteGraphDelta delta) {
        this.node = node;
        this.before = before;
        this.after = after;
        this.delta = delta;
    }

}
