/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class BorderDecoratorNode extends TransformNode {
    /**
     * 
     */
    private static final long serialVersionUID = -4982578347433716440L;

    protected Composite composite;
    protected Boolean visible = Boolean.TRUE;
    protected Rectangle2D bounds = null;
    protected float border = 1.0f;

    @SyncField("composite")
    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    @SyncField("visible")
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @PropertySetter("Stroke Width")
    @SyncField("border")
    public void setBorderWidth(Float borderWidth) {
        this.border = borderWidth != null ? borderWidth : 1.0f;
    }

    public boolean isVisible() {
        return visible;
    }

    @PropertySetter("Bounds")
    @SyncField("bounds")
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return bounds;
    }

    @Override
    public void render(Graphics2D g) {
        if(!visible) return;
        if(composite != null) {
            g.setComposite(composite);
        }

        if(this.border > 0.0f && bounds != null) {
            AffineTransform ot = g.getTransform();
            g.transform(transform);
            g.setStroke(new BasicStroke(this.border));
            g.setColor(Color.BLACK);
            g.draw(bounds);

            g.setTransform(ot);
        }
        super.render(g);
    }
}
