/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.rules.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.graph.rules.domain.MappingUtils;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.rules.domain.StructuralUtils;

public class RelatedObjectsAccessor
implements IDomainAccessor<StructuralResource, Collection<StructuralResource>> {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    Resource relation;
    boolean deleteExtraObjects;
    boolean useTypeResource;
    private boolean preventStructuralChanges = true;
    private boolean preventStructuralRootChanges = true;

    public RelatedObjectsAccessor(Resource relation, boolean deleteExtraObjects, boolean useTypeResource) {
        this.relation = relation;
        this.deleteExtraObjects = deleteExtraObjects;
        this.useTypeResource = useTypeResource;
    }

    public RelatedObjectsAccessor(Resource relation, boolean deleteExtraObjects, boolean useTypeResource, boolean preventStructuralChanges, boolean preventStructuralRootChanges) {
        this.relation = relation;
        this.deleteExtraObjects = deleteExtraObjects;
        this.useTypeResource = useTypeResource;
        this.preventStructuralChanges = preventStructuralChanges;
        this.preventStructuralRootChanges = preventStructuralRootChanges;
    }

    @Override
    public Collection<StructuralResource> get(ReadGraph g, StructuralResource element) throws MappingException {
        try {
            LOGGER.info((Object)"        RelatedObjectsAccessor.get");
            Resource res = this.getServiceResource(g, element);
            if (res == null) {
                return Collections.emptyList();
            }
            Collection coll = g.getObjects(res, this.relation);
            ArrayList<StructuralResource> result = new ArrayList<StructuralResource>(coll.size());
            for (Resource r : coll) {
                if (StructuralUtils.isStructuralInstance(g, r)) {
                    result.add(new StructuralResource(g, r, element.getContext(), r));
                    continue;
                }
                result.add(new StructuralResource(g, r, element.getContext()));
            }
            return result;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    private boolean preventChange(StructuralResource element) {
        return this.preventStructuralChanges && element.isStructural() && (!element.isStructuralRoot() || this.preventStructuralRootChanges);
    }

    @Override
    public boolean set(WriteGraph g, StructuralResource element, Collection<StructuralResource> value) throws MappingException {
        Resource res;
        block6: {
            block5: {
                LOGGER.info((Object)"        RelatedObjectsAccessor.set");
                res = this.getServiceResource((ReadGraph)g, element);
                if (res != null) break block5;
                return false;
            }
            if (!this.preventChange(element)) break block6;
            return false;
        }
        try {
            Resource[] arr = new Resource[value.size()];
            int i = 0;
            for (StructuralResource sr : value) {
                arr[i++] = sr.getResource();
            }
            return MappingUtils.synchronizeStatements(g, res, this.relation, arr, this.deleteExtraObjects);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    private Resource getServiceResource(ReadGraph g, StructuralResource element) {
        if (!this.useTypeResource) {
            return element.getResource();
        }
        return element.getTypeResource();
    }
}

