/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.rules.domain;

import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.rules.domain.StructuralUtils;

public class RelatedObjectAccessor
implements IDomainAccessor<StructuralResource, StructuralResource> {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    Resource relation;
    boolean useTypeResource;
    private boolean preventStructuralChanges = true;
    private boolean preventStructuralRootChanges = true;

    public RelatedObjectAccessor(Resource relation, boolean useTypeResource) {
        this.relation = relation;
        this.useTypeResource = useTypeResource;
    }

    public RelatedObjectAccessor(Resource relation, boolean useTypeResource, boolean preventStructuralChanges, boolean preventStructuralRootChanges) {
        this.relation = relation;
        this.useTypeResource = useTypeResource;
        this.preventStructuralChanges = preventStructuralChanges;
        this.preventStructuralRootChanges = preventStructuralRootChanges;
    }

    private boolean preventChange(StructuralResource element) {
        return this.preventStructuralChanges && element.isStructural() && (!element.isStructuralRoot() || this.preventStructuralRootChanges);
    }

    @Override
    public StructuralResource get(ReadGraph g, StructuralResource element) throws MappingException {
        Resource r;
        block6: {
            Resource res;
            block5: {
                try {
                    LOGGER.info((Object)"        RelatedObjectAccessor.get");
                    res = this.getServiceResource(g, element);
                    if (res != null) break block5;
                    return null;
                }
                catch (DatabaseException e) {
                    throw new MappingException(e);
                }
            }
            r = g.getPossibleObject(res, this.relation);
            if (r != null) break block6;
            return null;
        }
        if (StructuralUtils.isStructuralInstance(g, r)) {
            return new StructuralResource(g, r, element.getContext(), r);
        }
        return new StructuralResource(g, r, element.getContext());
    }

    @Override
    public boolean set(WriteGraph g, StructuralResource selement, StructuralResource value) throws MappingException {
        Resource element;
        block14: {
            block13: {
                Resource resource;
                block10: {
                    block12: {
                        block11: {
                            block9: {
                                try {
                                    LOGGER.info((Object)"        RelatedObjectAccessor.set");
                                    element = this.getServiceResource((ReadGraph)g, selement);
                                    if (element != null) break block9;
                                    return false;
                                }
                                catch (DatabaseException e) {
                                    throw new MappingException(e);
                                }
                            }
                            resource = g.getPossibleObject(element, this.relation);
                            if (resource != null) break block10;
                            if (value != null) break block11;
                            return false;
                        }
                        if (!this.preventChange(selement)) break block12;
                        return false;
                    }
                    g.claim(element, this.relation, value.getResource());
                    return true;
                }
                if (!resource.equals(value.getResource())) break block13;
                return false;
            }
            if (!this.preventChange(selement)) break block14;
            return false;
        }
        g.deny(element, this.relation);
        if (value != null) {
            g.claim(element, this.relation, value.getResource());
        }
        return true;
    }

    private Resource getServiceResource(ReadGraph g, StructuralResource element) {
        if (!this.useTypeResource) {
            return element.getResource();
        }
        return element.getTypeResource();
    }
}

