/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.schema;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.schema.ILinkType;

public class AdaptedLinkType<Range>
implements ILinkType<Resource, Range> {
    Resource domainType;
    Class<?> rangeType;

    public AdaptedLinkType(Resource domainType, Class<?> rangeType) {
        this.domainType = domainType;
        this.rangeType = rangeType;
    }

    @Override
    public Resource createDomainElement(WriteGraph g, Range rangeElement) throws MappingException {
        try {
            IAdaptable adaptable = (IAdaptable)rangeElement;
            Resource res = (Resource)adaptable.getAdapter(Resource.class);
            if (res == null) {
                throw new NullPointerException();
            }
            return res;
        }
        catch (Exception e) {
            throw new MappingException("Adapted object must implement IAdaptable interface to return the source Resource.", e);
        }
    }

    @Override
    public Range createRangeElement(ReadGraph g, Resource domainElement) throws MappingException {
        try {
            return (Range)g.adapt(domainElement, this.rangeType);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public void createDomain(WriteGraph graph, IBackwardMapping<Resource, Range> mapping, Resource domainElement, Range rangeElement) throws MappingException {
    }

    @Override
    public void createRange(ReadGraph graph, IForwardMapping<Resource, Range> mapping, Resource domainElement, Range rangeElement) throws MappingException {
    }

    @Override
    public boolean updateDomain(WriteGraph g, IBackwardMapping<Resource, Range> map, Resource domainElement, Range rangeElement) throws MappingException {
        return false;
    }

    @Override
    public boolean updateRange(ReadGraph g, IForwardMapping<Resource, Range> map, Resource domainElement, Range rangeElement) throws MappingException {
        return false;
    }
}

