/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.domain;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;

public class RelatedValueAccessor
implements IDomainAccessor<Resource, Object> {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    Resource relation;
    Resource valueType;

    public RelatedValueAccessor(Resource relation, Resource valueType) {
        this.relation = relation;
        this.valueType = valueType;
    }

    @Override
    public Object get(ReadGraph g, Resource element) throws MappingException {
        Resource valueResource;
        block3: {
            try {
                LOGGER.info((Object)"        RelatedValueAccessor.get");
                valueResource = g.getPossibleObject(element, this.relation);
                if (valueResource != null) break block3;
                return null;
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
        }
        return g.getValue(valueResource);
    }

    @Override
    public boolean set(WriteGraph g, Resource element, Object value) throws MappingException {
        Statement valueStatement;
        block12: {
            block11: {
                block9: {
                    block10: {
                        try {
                            LOGGER.info((Object)"        RelatedValueAccessor.set");
                            valueStatement = g.getPossibleStatement(element, this.relation);
                            if (valueStatement != null) break block9;
                            if (value != null) break block10;
                            return false;
                        }
                        catch (DatabaseException e) {
                            throw new MappingException(e);
                        }
                    }
                    Resource valueResource = g.newResource();
                    g.claim(valueResource, Layer0.getInstance((ReadGraph)g).InstanceOf, null, this.valueType);
                    g.claim(element, this.relation, valueResource);
                    g.claimValue(valueResource, value);
                    return true;
                }
                if (value != null) break block11;
                if (!valueStatement.isAsserted(element)) {
                    g.deny(valueStatement.getObject());
                    return true;
                }
                return false;
            }
            Object currentValue = g.getValue(valueStatement.getObject());
            if (!this.equals(currentValue, value)) break block12;
            return false;
        }
        if (!valueStatement.isAsserted(element)) {
            g.claimValue(valueStatement.getObject(), value);
        } else {
            Resource valueResource = g.newResource();
            g.claim(valueResource, Layer0.getInstance((ReadGraph)g).InstanceOf, null, this.valueType);
            g.claim(element, this.relation, valueResource);
            g.claimValue(valueResource, value);
        }
        return true;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 instanceof boolean[]) {
            Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof int[]) {
            Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof float[]) {
            Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof double[]) {
            Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof byte[]) {
            Arrays.equals((byte[])o1, (byte[])o2);
        }
        return o1.equals(o2);
    }
}

