package org.simantics.modeling.ui.view;

import java.util.Collection;
import java.util.Date;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.All;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.ChangeInformation;
import org.simantics.modeling.subscription.SubscriptionItemLabel;
import org.simantics.utils.format.ValueFormat;

public class Bean {

	public String createdBy = "";
	public String modifiedBy = "";
	public long modifiedAt = 0;
	public long createdAt = 0;
	public String name = "";
	public String path = "";
	public String types = "";
	
	public Bean() {
		
	}

	public Bean(ReadGraph graph, Resource r, ChangeInformation i, String baseURI) throws DatabaseException {
		
		Layer0 L0 = Layer0.getInstance(graph);
		ModelingResources MOD = ModelingResources.getInstance(graph);
		ChartResource CHART = ChartResource.getInstance(graph);

		Collection<Resource> principalTypes = graph.getPrincipalTypes(r);

		if (principalTypes.contains(MOD.Subscription)) {
			String label = graph.getPossibleRelatedValue2(r, L0.HasLabel, Bindings.STRING);
			setName((label != null && !label.isEmpty()) ? label : "<unnamed subscription>");
		} else if (principalTypes.contains(MOD.Subscription_Item)) {
			String label = SubscriptionItemLabel.resolveLabel(graph, r, ValueFormat.Default, true, true, false);
			setName(label);
		} else if (principalTypes.contains(CHART.Chart_Item)) {
			String label = graph.getPossibleRelatedValue2(r, L0.HasLabel, Bindings.STRING);
			setName((label != null && !label.isEmpty()) ? label : "<unlabeled chart item>");
		} else {

			Resource possibleComponent = graph.getPossibleObject(r, MOD.ElementToComponent);
			Resource possibleComposite = graph.getPossibleObject(r, MOD.DiagramToComposite);
			
			Resource nameResource = r;
			if(possibleComponent != null) nameResource = possibleComponent;
			if(possibleComposite != null) nameResource = possibleComposite;

			String name = Versions.getStandardNameString(graph, nameResource);
			
			if(possibleComponent != null) name += " Element";
			if(possibleComposite != null) name += " Diagram";
			
			setName(name);
			
		}
		
		StringBuilder types = new StringBuilder();
		for(Resource t : principalTypes) {
			if(types.length() > 0) types.append(" ");
			types.append(NameUtils.getSafeName(graph, t));
		}
		
		setTypes(types.toString());
		
		Resource parent = graph.getPossibleObject(r, L0.PartOf);
		if(parent != null) {
			String uri = graph.getPossibleURI(parent);
			if(uri.endsWith("/__CONTAINER__/__DIAGRAM__")) uri = uri.substring(0, uri.length()-"/__CONTAINER__/__DIAGRAM__".length());
			if(uri.endsWith("/__CONTAINER__")) uri = uri.substring(0, uri.length()-"/__CONTAINER__".length());
			if(uri.equals(baseURI)) uri = "<selected resource>";
			if(uri.startsWith(baseURI)) uri = uri.substring(baseURI.length());
			if(uri.startsWith("/Configuration/")) uri = uri.substring("/Configuration/".length());

			uri = uri.replace("http://Projects/Development%20Project/", "");
			uri = URIStringUtils.unescape(uri);
			
			if(graph.isInstanceOf(parent, MOD.Subscription)) {

				String name = graph.getPossibleRelatedValue(parent, L0.HasName, Bindings.STRING);
				String label = graph.getPossibleRelatedValue(parent, L0.HasLabel, Bindings.STRING);
				uri = uri.replace(name, label);
				
			}
			
			setPath(uri);
		} else {
			setPath("");
		}
		
		setCreatedBy(i.createdBy);
		setModifiedBy(i.modifiedBy);
		setModifiedAt(i.modifiedAt);
		setCreatedAt(i.createdAt);
		
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public String getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	public String getModifiedAt() {
		return All.sdfLong.format(new Date(modifiedAt));
	}

	public void setModifiedAt(long modifiedAt) {
		this.modifiedAt = modifiedAt;
	}

	public String getCreatedAt() {
		return All.sdfLong.format(new Date(createdAt));
	}

	public void setCreatedAt(long createdAt) {
		this.createdAt = createdAt;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getTypes() {
		return types;
	}

	public void setTypes(String types) {
		this.types = types;
	}

}