package org.simantics.modeling.ui.handlers.e4;

import javax.inject.Named;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.modeling.ui.documents.OpenPlainTextDocumentAdapter;
import org.simantics.modeling.ui.property.TypicalPropertyTester;
import org.simantics.modeling.ui.typicals.RuleChooserDialog;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class SyncCurrentTypicalTemplateToInstances {

    @CanExecute
    public boolean canExecute(@Named(IServiceConstants.ACTIVE_PART) MPart mActiveEditor) throws DatabaseException, InterruptedException {
        // TODO: Fix this when we get rid of CompatibilityEditors
        IEditorPart activeEditor = null;
        if (mActiveEditor != null && mActiveEditor.getObject()instanceof CompatibilityEditor) {
            CompatibilityEditor compEditor = (CompatibilityEditor) mActiveEditor.getObject();
            activeEditor = compEditor.getEditor();
        } else {
            // TODO: This is not good practice with E4 but an OK fallback for now
            activeEditor = WorkbenchUtils.getActiveEditor();
        }
        if (activeEditor == null)
            return false;
        if (DatabaseJob.inProgress())
            return false;
        IResourceEditorInput input = (IResourceEditorInput) activeEditor.getEditorInput();
        return TypicalPropertyTester.isTypicalMasterEditor(Simantics.getSession(), input.getResource());
    }
    
    @Execute
    public void execute(@Named(IServiceConstants.ACTIVE_SHELL) Shell shell, @Named(IServiceConstants.ACTIVE_PART) MPart mActiveEditor) {
        // TODO: Fix this when we get rid of CompatibilityEditors
        IEditorPart activeEditor = null;
        Object editor = mActiveEditor.getObject();
        if (editor instanceof CompatibilityEditor) {
            CompatibilityEditor compEditor = (CompatibilityEditor) editor;
            activeEditor = compEditor.getEditor();
        } else {
            // TODO: This is not good practice with E4 but an OK fallback for now
            activeEditor = WorkbenchUtils.getActiveEditor();
        }
        if (activeEditor == null)
            return;

        IResourceEditorInput input = (IResourceEditorInput) activeEditor.getEditorInput();
        Session session = Simantics.getSession();

//        if (!MessageDialog
//                .openConfirm(shell,
//                        "Synchronize Typical Template With Instances",
//                        "Are you sure you want to synchronize all instances of this typical template with the template?"))
//            return null;

        try {
            if (!TypicalPropertyTester.isTypicalMasterEditor(session, input.getResource())) {
                MessageDialog.openInformation(shell, "Not Synchronizing", "Currently active editor is not a typical diagram template editor.");
                return;
            }

            RuleChooserDialog.RuleResult result = RuleChooserDialog.choose(shell, "Synchronizing typical template to all its instances.", new Resource[] { input.getResource() });
            if(result == null) return;

            session.markUndoPoint();
            SyncTypicalTemplatesToInstances req = new SyncTypicalTemplatesToInstances(result.selectedRules, input.getResource()).logging(result.logging); 
            session.syncRequest(req);
            if (result.logging) {
                for(Resource log : req.logs)
                    new OpenPlainTextDocumentAdapter().openEditor(log);
            }
        } catch (Exception e) {
            ErrorLogger.defaultLogError(e);
        }
        return;
    }

}
