/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.ArrayList;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.diagram.ui.WorkbenchSelectionProvider;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * A canvas participant that listens to the #0 mouse selection and provides it
 * forward through the {@link IPostSelectionProvider} interface.
 * 
 * @author Tuukka Lehtonen
 */
public class WorkbenchStructuralSelectionProvider extends WorkbenchSelectionProvider {

    ResourceArray                                   suffix;

    public WorkbenchStructuralSelectionProvider(IThreadWorkQueue swt, ResourceArray appendToSelections) {
        this(swt, null, appendToSelections);
    }

    public WorkbenchStructuralSelectionProvider(IThreadWorkQueue swt, IWorkbenchPartSite site, ResourceArray appendToSelections) {
        super(swt, site);
        this.suffix = appendToSelections;
    }

    protected ISelection constructAdaptableSelection(Iterable<?> selection) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object o : selection) {
            if (o instanceof IElement) {
                IElement e = (IElement) o;
                Object object = e.getHint(ElementHints.KEY_OBJECT);
                if (object instanceof Resource) {
                    objects.add(suffix.prepended((Resource) object));
                } else {
                    objects.add(object);
                    objects.add(suffix);
                }
            } else {
                System.out.println("  unrecognized selection: " + o.getClass() + ": " + o);
            }
        }
        return new StructuredSelection(objects);
    }

}
