package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableWriteImplied;
import org.simantics.db.layer0.variable.Variables;

public class MonitorVariableWrite extends WriteRequest {

    final private Variable variable;
    final private String label;

    public MonitorVariableWrite(Variable variable, String label) {
        super(null);
        this.variable = variable;
        this.label = label;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {

        Variable converted = variable.getPossibleProperty(graph, Variables.CONVERTED_VALUE);
        if(converted != null) {
            converted.setValue(graph, label, Bindings.STRING);

            // Add a comment to metadata.
            CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
            graph.addMetadata(cm.add("Set value " + ObjectUtils.toString(label)));
        } else {
            new VariableWriteImplied(variable, label).perform(graph);
        }

    }

}
