package org.simantics.modeling.ui.diagram;

import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.scl.commands.Command;
import org.simantics.scl.commands.Commands;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ToggleProfileMonitorsContribution extends DynamicMenuContribution implements IExecutableExtension {

    String          name    = "";
    ImageDescriptor image   = null;
    boolean         allow = true;

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
    throws CoreException {
        if (data instanceof Map<?,?>) {
            @SuppressWarnings("unchecked")
            Map<String, String> args = (Map<String, String>) data;
            name = args.get("name");
            String imageId = args.get("image");
            image = Activator.getDefault().getImageRegistry().getDescriptor(imageId);
            allow = Boolean.parseBoolean(args.get("allow"));
        }
    }

    @Override
    protected Object[] getSelectedObjects() {
        return ResourceAdaptionUtils.toResources(getSelection());
    }

    @Override
    protected IContributionItem[] getContributionItems(ReadGraph graph, final Object[] elements) throws DatabaseException {
    	
    	if(elements.length == 0) return NONE;

    	Boolean allOk = true;
    	
		DiagramResource DIA = DiagramResource.getInstance(graph);
		for(Object object : elements) {
			Resource element = (Resource)object;
	        Boolean value = graph.getPossibleRelatedValue(element, DIA.Element_hideProfileMonitors, Bindings.BOOLEAN);
	        if(value == null) value = false;
	        if(value.equals(allow)) {
	        	allOk = false;
	        }
		}
		
		if(allOk) return NONE;
    	
    	return new IContributionItem[] {
    			
    			new ActionContributionItem(new Action(name, image) {
    				@Override
    				public void run() {
    					
    					Simantics.getSession().markUndoPoint();
    					Simantics.async(new WriteRequest() {

							@Override
							public void perform(WriteGraph graph) throws DatabaseException {
							    Command command = Commands.get(graph, "Simantics/Diagram/showProfileMonitors");
								for(Object object : elements) {
									Resource element = (Resource)object;
									command.execute(graph, graph.syncRequest(new IndexRoot(element)), element, allow);
								}
							}
    						
    					});

    				}
    			})
    	};
    		
    }

}
