/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.Map;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.modeling.ui.componentTypeEditor.LiftPropertiesDialog.LiftedProperty;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;

public class LiftPropertiesDialog extends ResourceSelectionDialog3<LiftedProperty> {

	private boolean mapProperties = false;
	private Button checkbox;

	public static class LiftedProperty extends Tuple3 {

		public LiftedProperty(Resource component, Resource componentType, Resource predicate) {
			super(component, componentType, predicate);
		}
		
		public Resource getComponent() {
			return (Resource)get(0);
		}

		public Resource getComponentType() {
			return (Resource)get(1);
		}

		public Resource getPredicate() {
			return (Resource)get(2);
		}

	}
	
	public LiftPropertiesDialog(Shell shell,
			Map<LiftedProperty, Pair<String, ImageDescriptor>> parameter, String title) {
		super(shell, parameter, title);
	}

	@Override
	protected IDialogSettings getBaseDialogSettings() {
		return null;
	}

	@Override
	protected Control createExtendedContentArea(Composite parent) {
		Composite c = new Composite(parent, SWT.NONE);
		GridDataFactory.fillDefaults().grab(true, false).applyTo(c);
		GridLayoutFactory.swtDefaults().numColumns(2).applyTo(c);
//		Label l = new Label(c, SWT.NONE); 
//		l.setText("Map lifted properties into interface");
//		GridDataFactory.fillDefaults().grab(false, false).applyTo(l);
		checkbox = new Button(c, SWT.CHECK);
		checkbox.setText("Map lifted properties into interface");
		checkbox.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				widgetDefaultSelected(e);
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				mapProperties = checkbox.getSelection();
			}
		});
		GridDataFactory.fillDefaults().grab(true, false).applyTo(checkbox);
		return super.createExtendedContentArea(parent);
	}

	@Override
	public void create() {
		super.create();
		checkbox.setFocus();
	}

	public boolean getMapProperties() {
		return mapProperties;
	}

}