package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.modeling.ui.modelBrowser.handlers.StandardCopyHandler;

public class Copy implements ActionFactory, ActionFactory2 {

	@Override
    public Runnable create(Object target) {
		return create(Collections.singletonList(target));
	}

	@Override
    public Runnable create(Collection<?> target) {

		final ArrayList<Resource> resources = new ArrayList<Resource>();
		
		for(Object o : target) {
			if(!(o instanceof Resource))
				return null;
			resources.add((Resource)o);
		}
        return () -> {
            Job job = new Job("Copy") {

                @Override
                protected IStatus run(IProgressMonitor monitor) {
                    StandardCopyHandler.copyResourcesToClipboard(resources.toArray(new Resource[resources.size()]), null, monitor);
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        };
    }

}
